*-----------------------------------------------------------
* Program    :
* Written by :
* Date       :
* Description:	Prt
*-----------------------------------------------------------
*
*	=========== PrtNoEcho ():null ======================
* Set Port not to echo keystrokes
PrtNoEcho:	* ALTERS d0,d1
	clr.l	d1
	move.l	d1,(a6)
	move.l	d1,d0
	move.b	#12,d0
	trap	#15
	rts
*
*	=========== PrtGetRawKey ():long =====================
* Get a single keystroke
PrtGetRawKey:	* ALTERS d0
	clr.l	d0
	move.l	d0,(a6)
	move.b	#5,d0
	trap	#15		* result in d1.b
	move.b	d1,3(a6)	* Result = Key
	rts
*
*	========== PrtDispNib (Nibble:long):null =============
* Display nibble as hex char
PrtDispNib:	* ALTERS d0,d1,a0
	halfmark
	  move.l -MARKBYTS(a6),-(a7)
	  lea.l	 MARKBYTS(a7),a6
	  lea.l	 CharAsc,a0
	  jsr	 (a0)
	unmark
	move.l	(a7)+,d0
	mark
	  move.l d0,-(a7)
	  lea.l	PrtDispKey,a0
	  jsr	(a0)
	unmarkdrop
	rts
*
*	============ Prt(v: chvecptr): vecptr ===========
* Display tos chvec bytes to ix
Prt:		* ALTERS d0,d1,d2,d3,d4,a0
	move.l	-MARKBYTS(A6),d0	* v
	move.l	d0,(a6)			* set result
*	d3 = VecCurIx(v)
	halfmark
		move.l	d0,-(a7)	* v
		lea.l	MARKBYTS(a7),a6
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark				* tos is CurIx
	move.l	(a7)+,d3		* stack as at call
*	if d3 >= 0 then
	blt	prtend
*		d4 = 0
		clr.l	d4			* d4 counts up
*		repeat
prtlp:
			halfmark
	 	 		move.l	-MARKBYTS(a6),-(a7) *v
		  		lea.l	MARKBYTS(a7),a6
		  		move.l	d4,-(a7)	* ix
		  		moveq.l	#1,d0
				move.l	d0,-(a7)	* val=true
		  		lea.l	VecEltI,a0
		  		jsr	(a0)
			unmark
			move.l	(a7)+,d0
			mark
				move.l	d0,-(a7)
				lea.l	PrtDispKey,a0
				jsr	(a0)
			unmarkdrop
*			d4 ++
			addq.l	#1,d4
* 		until (d3-- == -1)
		dbf	d3,prtlp
*	endif
prtend:
	rts
*
* 	=========== PrtDispChLong( ch:long, v:long, digcnt:long):0 =========
*		Displays ch if not NUL, then
*		displays rightmost min(LNGNIBS,digcnt) hex nibbles of v.
PrtDispChLong	* ALTERS d0,d1,d2,d3,a0
*	if (ch <> NUL ) then 
	move.l	-MARKBYTS(a6),d0		* ch
	beq	pdcnodelim
*		drop PrtDispKey(ch)
		mark
			move.l	d0,-(a7)
			lea.l	PrtDispKey,a0
			jsr	(a0)
		unmarkdrop
*	endif
pdcnodelim:
*	d0 = digcnt
	move.l	-(MARKBYTS+2*LNGBYTS)(a6),d0	* digcnt
*	if (d0 <= 0) then
	bgt	pdcdigcntnotlow
*		d0 = 1
		moveq.l	#1,d0
*	else if d0 > LNGNIBS then
	bra	pdcdigcntok
pdcdigcntnotlow:
	moveq.l	#LNGNIBS,d1
	cmp.l	d1,d0
	ble	pdcdigcntok
*		d0 = LNGNIBS
		move.l	d1,d0
*	endif
pdcdigcntok:
	move.l	d0,-(MARKBYTS+2*LNGBYTS)(a6)
	moveq.l	#LNGNIBS-1,d2
	move.l	-(MARKBYTS+LNGBYTS)(a6),d3	* v
*	repeat
pdclp:
		rol.l		#NIBBITS,d3 * nxt hiorder nib->low nib
*		if (d2 < digcnt) then
		cmp.l		-(MARKBYTS+2*LNGBYTS)(a6),d2
		bge	pdcsuppress
*			drop PrtDispNib(d3)
			mark	
				move.l	d3,-(a7)
				lea.l	PrtDispNib,a0
				jsr	(a0)
			unmarkdrop
*		endif	
pdcsuppress:	
*	until (d2-- == -1)
	dbf	d2,pdclp
	rts
*
*	================= PrtDbg((pc:long, sr:word): null) ==============
*	(Used in conjunction with ; operator)
PrtDbg:
*	Trap handler - arrive here with sr.w in tos and pc.l on tos-1 
*	and STACK NOT LONG ALIGNED
	clr.w	-(a7)	* stack now long aligned
*	drop = PrtDispKey(CR)
	mark
		move.l	#Char_CR,-(a7)
		lea.l	PrtDispKey,a0
		jsr	(a0)
	unmarkdrop
*	drop = PrtDispKey(LF)
	mark
		move.l	#Char_LF,-(a7)
		lea.l	PrtDispKey,a0
		jsr	(a0)
	unmarkdrop
*	drop = PrtDispKey(DOLLAR)
	mark
		move.l	#Char_DOLLAR,-(a7)
		lea.l	PrtDispKey,a0
		jsr	(a0)
	unmarkdrop
*	drop = PrtDispChLong(NUL,tos,WRDNIBS)
	mark
		clr.l	-(a7)		* NUL
		move.l	LNGBYTS(a6),-(a7) * long-extended SR
		moveq.l	#WRDNIBS,d0
		move.l	d0,-(a7)
		lea.l	PrtDispChLong,a0
		jsr	(a0)
	unmarkdrop
*	drop = PrtDispKey(SEMI)
	mark
		move.l	#Char_SEMI,-(a7)
		lea.l	PrtDispKey,a0
		jsr	(a0)
	unmarkdrop
*	tos-1 -= WRDBYTS
	move.l	LNGBYTS(a7),d0
	subq.l	#WRDBYTS,d0
	move.l	d0,LNGBYTS(a7)
*	drop = PrtDispChLong(NUL,tos-1,LNGNIBS)
	mark
		clr.l	-(a7)		* NUL
		move.l	LNGBYTS+LNGBYTS(a6),-(a7) * PC
		moveq.l	#LNGNIBS,d0
		move.l	d0,-(a7)
		lea.l	PrtDispChLong,a0
		jsr	(a0)
	unmarkdrop
*	drop = PrtGetRawKey()
	mark
		lea.l	PrtGetRawKey,a0
		jsr	(a0)
	unmarkdrop
*	
*	(tos-1) = (PrtNop)	* saved instruction set by ;
	move.l	d0,a0
	move.w	PrtNop,(a0)
	lea.l	WRDBYTS(a7),a7
	rte
*
PrtBrk:	trap	#14
PrtNop:	nop
*	
*	=========== PrtDispKey (Key:long): 0 ==========	
* Display tos byte 
PrtDispKey:	* ALTERS d0,d1
	move.l	LNGBYTS(a7),d1	* Key
	move.l	d1,(a6)		* result
	clr.l	d0
	move.b	#6,d0
	trap	#15
	rts
*
*	=============== Name Vectors =================
*
		ORG	(*+3)&-4
*
_PrtNoEcho	DC.L	_CharCtl
		DC.W	12
		DC.W	10
		DC.B	'_PrtNoEcho',0,0,0,0,0,0
*
_PrtGetRawKey	DC.L	_PrtNoEcho
		DC.W	12
		DC.W	13
		DC.B	'_PrtGetRawKey',0,0,0
*
_PrtDispNib	DC.L	_PrtGetRawKey
		DC.W	12
		DC.W	11
		DC.B	'_PrtDispNib',0,0,0,0,0
*
_PrtDispChLong	DC.L	_PrtDispNib
		DC.W	12
		DC.W	14
		DC.B	'_PrtDispChLong',0,0
*
_Prt		DC.L	_PrtDispChLong
		DC.W	8
		DC.W	4
		DC.B	'_Prt',0,0,0,0
*
_PrtDbg		DC.L	_Prt
		DC.W	8
		DC.W	7
		DC.B	'_PrtDbg',0
*
_PrtBrk		DC.L	_PrtDbg
		DC.W	8
		DC.W	7
		DC.B	'_PrtBrk',0
*
_PrtNop		DC.L	_PrtBrk
		DC.W	8
		DC.W	7
		DC.B	'_PrtNop',0
*
_PrtDispKey	DC.L	_PrtNop
		DC.W	12
		DC.W	11
		DC.B	'_PrtDispKey',0,0,0,0,0
*
*	================== Dic Entries ========================
*
__PrtNoEcho	DC.L	__CharCtl
		DC.L	_PrtNoEcho
		DC.L	PrtNoEcho
*
__PrtGetRawKey	DC.L	__PrtNoEcho
		DC.L	_PrtGetRawKey
		DC.L	PrtGetRawKey
*
__PrtDispNib	DC.L	__PrtGetRawKey
		DC.L	_PrtDispNib
		DC.L	PrtDispNib
*
__PrtDispChLong	DC.L	__PrtDispNib
		DC.L	_PrtDispChLong
		DC.L	PrtDispChLong
*
__Prt		DC.L	__PrtDispChLong
		DC.L	_Prt
		DC.L	Prt
*
__PrtDbg	DC.L	__Prt
		DC.L	_PrtDbg
		DC.L	PrtDbg
*
__PrtBrk	DC.L	__PrtDbg
		DC.L	_PrtBrk
		DC.L	PrtBrk
*
__PrtNop	DC.L	__PrtBrk
		DC.L	_PrtNop
		DC.L	PrtNop
*
__PrtDispKey	DC.L	__PrtNop
		DC.L	_PrtDispKey
		DC.L	PrtDispKey
*


























































*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
